<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Films Populaires - TMDb</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #121212;
            color: white;
            margin: 0;
            padding: 20px;
            text-align: center;
        }
        h1 {
            color: #ffcc00;
        }
        .movies-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 20px;
        }
        .movie-card {
            width: 200px;
            background-color: #1e1e1e;
            padding: 10px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(255, 255, 255, 0.1);
            transition: transform 0.3s;
        }
        .movie-card:hover {
            transform: scale(1.05);
        }
        .movie-poster {
            width: 100%;
            border-radius: 10px;
        }
        .movie-title {
            font-size: 16px;
            font-weight: bold;
            margin: 10px 0;
        }
        .movie-rating {
            color: #ffcc00;
        }
    </style>
</head>
<body>

    <h1>🎬 Films Populaires</h1>
    <div id="movies" class="movies-container"></div>

    <script>
        // Clé API (Assure-toi qu'elle est valide)
        const API_URL = "https://api.themoviedb.org/3/movie/popular?language=fr-FR&page=5";
        const API_KEY = "eyJhbGciOiJIUzI1NiJ9.eyJhdWQiOiI5MTU1OGY0NDcxMDA0YTUwYTIyZmQ1OGRkZDBlODVmNyIsIm5iZiI6MTczODg5MDAxMS4yMDg5OTk5LCJzdWIiOiI2N2E1NWIxYjRkYzA1MmJhNTU4NWQ2OGIiLCJzY29wZXMiOlsiYXBpX3JlYWQiXSwidmVyc2lvbiI6MX0.DpcwfUZsWWiPWYv_nTzABDE76HjStpBArLM_55Omkkk.";

        async function fetchMovies() {
            try {
                const response = await fetch(API_URL, {
                    headers: {
                        "Authorization": `Bearer ${API_KEY}`,
                        "Accept": "application/json"
                    }
                });
                if (!response.ok) {
                    throw new Error("Erreur lors de la récupération des films");
                }
                const data = await response.json();
                displayMovies(data.results);
            } catch (error) {
                console.error("Erreur :", error);
                document.getElementById("movies").innerHTML = "<p>Impossible de charger les films.</p>";
            }
        }

        function displayMovies(movies) {
            const moviesContainer = document.getElementById("movies");
            moviesContainer.innerHTML = "";

            movies.forEach(movie => {
                const movieCard = document.createElement("div");
                movieCard.classList.add("movie-card");

                const moviePoster = document.createElement("img");
                moviePoster.classList.add("movie-poster");
                moviePoster.src = `https://image.tmdb.org/t/p/w500${movie.poster_path}`;
                moviePoster.alt = movie.title;

                const movieTitle = document.createElement("div");
                movieTitle.classList.add("movie-title");
                movieTitle.textContent = movie.title;

                const movieRating = document.createElement("div");
                movieRating.classList.add("movie-rating");
                movieRating.textContent = `⭐ ${movie.vote_average.toFixed(1)}`;

                movieCard.appendChild(moviePoster);
                movieCard.appendChild(movieTitle);
                movieCard.appendChild(movieRating);

                moviesContainer.appendChild(movieCard);
            });
        }

        // Charger les films au démarrage
        fetchMovies();
    </script>

</body>
</html>
